#include "obse/Script.h"
#include "EditorAPI.h"
#include "string.h"

#if CS_VERSION == CS_VERSION_1_2
	FormMap* g_FormMap = (FormMap *)0x009EE18C;		// currently unused
	const _GetFormByID GetFormByID = (_GetFormByID)(0x0047B340);
	const _FormHeap_Allocate FormHeap_Allocate = (_FormHeap_Allocate)0x00401E80;
	const _FormHeap_Free FormHeap_Free = (_FormHeap_Free)0x00401EA0;
	const _Oblivion_DynamicCast Oblivion_DynamicCast = (_Oblivion_DynamicCast)0x0088DC0C;
#elif CS_VERSION == CS_VERSION_1_0
	const _GetFormByID GetFormByID = (_GetFormByID)(0x00475430);
	const _FormHeap_Allocate FormHeap_Allocate = (_FormHeap_Allocate)0x00401E40;
	const _FormHeap_Free FormHeap_Free = (_FormHeap_Free)0x00401E60;
	const _Oblivion_DynamicCast Oblivion_DynamicCast = (_Oblivion_DynamicCast)0x008AB025;
#else
#error unsupported CS version
#endif

void ShowCompilerError(ScriptLineBuffer* lineBuf, const char * fmt, ...)
{

	char errorHeader[0x400];
	UInt32 offset = sprintf_s(errorHeader, 0x400, "Error on line %d\n\n", lineBuf->lineNumber);

	va_list	args;
	va_start(args, fmt);

	char	errorMsg[0x200];
	vsprintf_s(errorMsg, 0x200, fmt, args);

	strcat_s(errorHeader, 0x400, errorMsg);
	MessageBox(NULL, errorHeader, "OBSE", MB_OK | MB_ICONEXCLAMATION);

	va_end(args);
}

bool String::Set(const char * src)
{
	if (!src) {
		FormHeap_Free(m_data);
		m_data = 0;
		m_bufLen = 0;
		m_dataLen = 0;
		return true;
	}
	
	UInt32	srcLen = strlen(src);

	// realloc if needed
	if(srcLen > m_bufLen)
	{
		FormHeap_Free(m_data);
		m_data = (char *)FormHeap_Allocate(srcLen + 1);
		m_bufLen = m_data ? srcLen : 0;
	}

	if(m_data)
	{
		strcpy_s(m_data, m_bufLen + 1, src);
		m_dataLen = srcLen;
	}
	else
	{
		m_dataLen = 0;
	}

	return m_data != NULL;
}

String::~String()
{

}







