#pragma once

#include <map>
#include <set>
#include "Serialization.h"

// simple template class used to support OBSE custom data types (strings, arrays, etc)

template <class Var>
class VarMap
{
protected:
	typedef std::map<UInt32, Var*> _VarMap;
	typedef std::set<UInt32> _TmpVars;

	UInt32	GetUnusedID()
	{
		UInt32 id = 1;
		_VarMap::iterator itEnd = vars.end();
		while (vars.find(id) != itEnd)
		{
			id++;
		}
		return id;
	}


	_VarMap	vars;
	_TmpVars		tempVars;		// set of IDs of temporary vars, makes for easy cleanup

public:
	VarMap()
	{
		//
	}

	~VarMap()
	{
		//
	}

	Var*	Get(double varID)
	{
		if (varID != 0) {
			_VarMap::iterator it = vars.find(varID);
			if (it != vars.end())
				return it->second;
		}
		return NULL;
	}

	bool	VarExists(UInt32 varID)
	{
		if (Get(varID))
			return true;
		else
		{
			_MESSAGE("Internal Error: initialized variable %d not found in varmap", varID);
			return false;
		}
	}

	void	Delete(UInt32 varID)
	{
		Var* var = Get(varID);
		if (var)
		{
			delete var;
			vars.erase(varID);
		}
	}

	void Reset(OBSESerializationInterface* intfc)
	{
		_VarMap::iterator itEnd = vars.end();
		for (_VarMap::iterator iter = vars.begin();
				iter != itEnd;
				++iter)
		{
			delete iter->second;
		}

		vars.clear();
	}

	void	MarkTemporary(UInt32 varID, bool bTemporary)
	{
		if (bTemporary)
			tempVars.insert(varID);
		else
			tempVars.erase(varID);
	}

	bool IsTemporary(UInt32 varID)
	{
		return (tempVars.find(varID) != tempVars.end()) ? true : false;
	}
};