#include "GameTasks.h"
#include "GameAPI.h"
#include "GameForms.h"
#include "GameObjects.h"
#include "Hooks_Gameplay.h"

// Doesn't support Oblivion v1.1 yet, so disabled
bool IOManager::IsInQueue(TESObjectREFR *refr) 
{
#if 0
	for (LockFreeQueue< NiPointer<IOTask> >::Node *node = taskQueue->head->next; node; node = node->next) 
	{
		QueuedReference *qr = (QueuedReference *)(node->data, 0, RTTI_IOTask, RTTI_QueuedReference, 0);
		if (!qr)
			continue;

		if (qr->refr == refr)
			return true;
	}
#endif
	return false;
}

void IOManager::DumpQueuedTasks()
{
#if 0
	_MESSAGE("Dumping queued tasks:");
	for (LockFreeQueue< NiPointer<IOTask> >::Node *node = taskQueue->head->next; node; node = node->next)
	{
		QueuedReference* qr = OBLIVION_CAST(node->data, IOTask, QueuedReference);
		if (!qr)
			continue;
		else if (qr->refr)
		{
			Console_Print("\t%s (%08x)", GetFullName(qr->refr), qr->refr->refID);
			_MESSAGE("\t%s (%08x)", GetFullName(qr->refr), qr->refr->refID);
		}
		else
			_MESSAGE("NULL reference");
	}
#endif

}

IOManager* IOManager::GetSingleton()
{
#if OBLIVION_VERSION == OBLIVION_VERSION_1_1
	return *((IOManager**)0x00AEBE80);
#elif OBLIVION_VERSION == OBLIVION_VERSION_1_2
	return *((IOManager**)0x00B33A10);
#elif OBLIVION_VERSION == OBLIVION_VERSION_1_2_416
	return *((IOManager**)0x00B33A10);
#else
#error unsupported Oblivion version
#endif
}

void IOManager::QueueForDeletion(TESObjectREFR* refr)
{
	QueueRefForDeletion(refr);
}